/******************************************************************************/
class EventTrigger : Game.Obj
{
public:
            EventTrigger();
   virtual ~EventTrigger();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );

   virtual Bool update();
   virtual UInt drawPrepare();
   virtual void drawBlend  ();
   
   virtual Vec    pos   (                ) final { return m_CenterPos; } // get position
   virtual void   pos   (C Vec    &pos   ) final { m_CenterPos = pos;  } // set position
   virtual Matrix matrix(                ) final { return m_Matrix;    } // get matrix
   virtual void   matrix(C Matrix &matrix) final { m_Matrix = matrix;  } // set matrix, for most classes 'matrix' should be normalized 
   
   void SetEnabled(bool enable) { m_Enabled = enable; }
   
private:

   void CallEnterEvents();
   void CallInsideEvents();
   void CallExitEvents();
   
   void CheckPlayerTriggerRelation();

   UID m_EnterEventsID, m_ExitEventsID,  m_InsideEventsID;
   EventGroup* m_EventGroupEnter, *m_EventGroupExit, *m_EventGroupInside;
   ENUM_FREQUENCY m_InsideUpdateFrequency;
   float m_InsideLastUpdate;
    
   bool   m_InTrigger, m_Enabled, m_CanTriggerAgain, m_FirstTick;
   Vec    m_CenterPos;
   Matrix m_Matrix;
   float  m_InsideTimer;
   
   
   Box m_Box;
}
/******************************************************************************/
EventTrigger::EventTrigger() : m_InsideLastUpdate(0), m_EventGroupEnter(null), m_EventGroupExit(null), m_EventGroupInside(null),
                               m_Enabled(true), m_InTrigger(false), m_CanTriggerAgain(false), 
                               m_FirstTick(true), m_CenterPos(0), m_Matrix(0), m_Box(0), m_InsideTimer(0)  
{
   
}
EventTrigger::~EventTrigger()
{
   
}
/******************************************************************************/
void EventTrigger::create(Object &obj)
{
      // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("Enabled"))                m_Enabled = p.asBool();
   if(Param *p = obj.findParam("CanTriggerAgain"))        m_CanTriggerAgain = p.asBool();
   if(Param *p = obj.findParam("Enter_EventGroupUID"))    m_EnterEventsID = p.asID();
   if(Param *p = obj.findParam("Exit_EventGroupUID"))     m_ExitEventsID = p.asID();
   if(Param *p = obj.findParam("Inside_EventGroupUID"))   m_InsideEventsID = p.asID();
   if(Param *p = obj.findParam("Inside_UpdateFrequency")) m_InsideUpdateFrequency = (ENUM_FREQUENCY)p.asEnum();
   
   m_CenterPos = obj.matrix.pos;
   m_Matrix    = obj.matrix;
   Vec scale   = m_Matrix.scale();
   m_Box.set(scale.x, scale.y, scale.z, m_CenterPos); 
}
/******************************************************************************/
void EventTrigger::AfterCreate()
{
   m_EventGroupEnter  = GetEventGroupForID(m_EnterEventsID);  
   m_EventGroupExit   = GetEventGroupForID(m_ExitEventsID); 
   m_EventGroupInside = GetEventGroupForID(m_InsideEventsID);
}
/******************************************************************************/
Bool EventTrigger::update()
{
   if(m_FirstTick)
   {
      AfterCreate();
      
      m_FirstTick = false;
   }
           
   CheckPlayerTriggerRelation();
   
   return true;
}
/******************************************************************************/
// Check if the player is in the trigger zone.
// m_EnteredTrigger will be true just when the player enters the zone (false again right after)
// m_LeftTrigger will be true just when the player exits the zone (false again right after)
/******************************************************************************/
void EventTrigger::CheckPlayerTriggerRelation()
{
   if(!m_Enabled)
   {
      return;
   }
   
   Vec playerPos = Players[0].pos();
   bool inTrigger = Cuts(m_Box, Players[0].ctrl.actor.shape(false).capsule); 

   // Player just entered
   if(inTrigger && !m_InTrigger)
   {
      CallEnterEvents();
   }
   // Player just Left
   else if(!inTrigger && m_InTrigger)
   {
      CallExitEvents();
      
      m_InsideTimer = 0;
      
      if(!m_CanTriggerAgain)
         m_Enabled = false;
   }
   
   if(m_InTrigger)
   {
      m_InsideTimer += Time.d();
      
      switch(m_InsideUpdateFrequency)
      {
         case EVERY_FRAME:
            CallInsideEvents();
            break;
         
         case EVERY_SECOND:
            if(m_InsideTimer >= m_InsideLastUpdate + 1 )
            {
               m_InsideLastUpdate = m_InsideTimer;
               CallInsideEvents();
            }
            break;
      }
   }
   
   
   m_InTrigger = inTrigger;
}
/******************************************************************************/
void EventTrigger::CallEnterEvents()
{
   if(m_EventGroupEnter != null)
   {
      m_EventGroupEnter.Triggered();
   }
}
/******************************************************************************/
void EventTrigger::CallInsideEvents()
{
   if(m_EventGroupInside != null)
   {
      m_EventGroupInside.Triggered();
   }
}
/******************************************************************************/
void EventTrigger::CallExitEvents()
{
   if(m_EventGroupExit != null)
   {
      m_EventGroupExit.Triggered();
   }
}
/******************************************************************************/
UInt EventTrigger::drawPrepare() 
{
   // Draw the trigger zone when in debug mode
#if DEBUG
   return IndexToFlag(RM_BLEND);
#else 
   return 0;  
#endif
}
/******************************************************************************/
void EventTrigger::drawBlend()
{
   Color drawColor = GREY;
   if(m_Enabled)
   { 
      if(m_InTrigger) drawColor = GREEN;
      else drawColor = RED;
   }  
   
   SetMatrix();
   m_Box.draw(drawColor, false);
}